#include <bits/stdc++.h>

int MUL = 239;
int MAGIC = 750;
long long inf = 1e18;

const int MAX = (int) 2e6 + 10;
int next[2][MAX];
int nextOld[2][MAX];
int nextLen[2][MAX];
int nextHash[2][MAX];
bool valid[MAX];
int cost[MAX];
int poww[MAX];
int sz = 0;

int get() {
  nextOld[0][sz] = nextOld[1][sz] = next[0][sz] = next[1][sz] = -1;
  cost[sz] = (int) 1e9;
  sz++;
  return sz - 1;
}

int root;

using std::vector;
using std::string;

void add(string s, int curCost, int now) {
  for (int i = 0; i < s.length(); i++) {
    int go = s[i] - '0';
    if (next[go][now] == -1) {
      nextOld[go][now] = next[go][now] = get();
    }
    now = next[go][now];
    cost[now] = std::min(cost[now], curCost);
  }
}

vector<int> getHash(string s) {
  vector<int> res(s.length() + 1);
  for (int i = 0; i < s.length(); i++) {
    res[i + 1] = (res[i] * MUL + s[i] - '0' + 1);
  }
  return res;
}

int get(vector<int> &hash, int l, int r) {
  int res = (hash[r + 1] - hash[l] * poww[r - l + 1]);
  return res;
}

void go(int v) {
  valid[v] = true;
  for (int i = 0; i < 2; i++) {
    if (next[i][v] != -1) {
      int to = next[i][v], len = 1, hash = i + 1;
      while (len < MAGIC - 2) {
        int cnt = (next[0][to] != -1 ? 1 : 0)
                  + (next[1][to] != -1 ? 1 : 0);
        int to2 = next[0][to] + next[1][to] + 1;
        if (cnt == 1 && cost[to] == cost[to2]) {
          len++;
          int id = next[0][to] != -1 ? 1 : 2;
          hash = ((hash * MUL + id));
          to = next[id - 1][to];
        } else {
          break;
        }
      }
      nextLen[i][v] = len;
      nextHash[i][v] = hash;
      next[i][v] = to;
      go(to);
    }
  }
}

int main() {
  std::ios::sync_with_stdio(false);
  int n;
  std::cin >> n;
  poww[0] = 1;
  for (int i = 1; i < MAX; i++) {
    poww[i] = (poww[i - 1] * MUL);
  }
  string s;
  std::cin >> s;
  int len = (int)s.length();
  root = get();
  int rootRev = get();
  for (int i = 0; i < n; i++) {
    int cost;
    std::cin >> cost;
    string tmp;
    std::cin >> tmp;
    add(tmp, cost, root);
    std::reverse(tmp.begin(), tmp.end());
    add(tmp, cost, rootRev);
  }
  go(root);
  go(rootRev);
  vector<int> hash = getHash(s);
  string sRev = s;
  reverse(sRev.begin(), sRev.end());
  vector<int> hashRev = getHash(sRev);
  vector<long long> dp(s.length() + 1);
  for (int i = 0; i <= s.length(); i++) {
    dp[i] = inf;
  }
  dp[0] = 0;
    for (int start = 0; start <= len; start++) {
      for (int i = start + 1; i <= len && i < start + MAGIC; i++) {
        dp[start] = std::min(dp[start], dp[i]);
      }
      {
        int cur = rootRev;
        int pos = start - 1;
        for (int iter = 0; iter < 2; iter++) {
          for (int j = 0; pos >= 0
                          && (j < MAGIC || !valid[cur]); j++) {
            int id = s[pos] - '0';
            if (nextOld[id][cur] == -1) {
              break;
            }
            cur = nextOld[id][cur];
            pos--;
            dp[start] =
              std::min(dp[start], dp[pos + 1] + cost[cur]);
          }
          if (iter == 1) {
            break;
          }
          if (valid[cur] && pos >= 0) {
            while (pos >= 0) {
              int id = s[pos] - '0';
              if (next[id][cur] == -1) {
                break;
              }
              int needLen = nextLen[id][cur];
              if (needLen <= pos + 1) {
                int realHash = get(hashRev,
                                   len - pos - 1, len - pos + needLen - 2);
                if (realHash == nextHash[id][cur]) {
                  pos -= needLen;
                  cur = next[id][cur];
                } else {
                  break;
                }
              } else {
                break;
              }
              dp[start] = std::min(dp[start], dp[pos + 1]
                                              + cost[cur]);
            }
          } else {
            break;
          }
        }
      }
      for (int i = start - 1; i >= 0 && i > start - MAGIC; i--) {
        dp[i] = std::min(dp[i], dp[start]);
      }
      if (dp[start] >= inf) {
        continue;
      }
      {
        int cur = root;
        int pos = start;
        for (int iter = 0; iter < 2; iter++) {
          for (int j = 0; pos < len
                          && (j < MAGIC || !valid[cur]); j++) {
            int id = s[pos] - '0';
            if (nextOld[id][cur] == -1) {
              break;
            }
            cur = nextOld[id][cur];
            pos++;
            dp[pos] = std::min(dp[pos], dp[start] + cost[cur]);
          }
          if (iter == 1) {
            break;
          }
          if (valid[cur] && pos < len) {
            while (pos < len) {
              int id = s[pos] - '0';
              if (next[id][cur] == -1) {
                break;
              }
              int needLen = nextLen[id][cur];
              if (needLen + pos <= len) {
                int realHash = get(hash, pos, pos + needLen - 1);
                if (realHash == nextHash[id][cur]) {
                  pos += needLen;
                  cur = next[id][cur];
                } else {
                  break;
                }
              } else {
                break;
              }
              dp[pos] = std::min(dp[pos], dp[start] + cost[cur]);
            }
          } else {
            break;
          }
        }
      }
    }
  std::cout << (dp[len] >= inf ? -1 : dp[len]) << std::endl;
}
